/* pxplus-ace helper javascript - Common functions used by ace editor object

 The following changes have been made to src-noconflict\ace.js and if we updgrade ace we will need to apply these changes again:

215c215
<     (appName == "Microsoft Internet Explorer" || appName.indexOf("MSAppHost") >= 0)
---
>     (appName == "Microsoft Internet Explorer" || appName == "Netscape" || appName.indexOf("MSAppHost") >= 0)
1759a1760
>                 if (useragent.isWin) return clipboardData.setData(mime, data.replace(/\n/g, "\r\n")) !== false;
1761a1763
>                 if (useragent.isWin) return clipboardData.getData(mime).replace(/\r\n/g, "\n");
15937c15939
<     this.TAB_CHAR = "\u2014"; //"\u21E5";
---
>     this.TAB_CHAR = "\u2192"; //"\u21E5";
16025c16027
<                 span.textContent = lang.stringRepeat(this.TAB_CHAR, i);
---
>                 span.textContent = this.TAB_CHAR + lang.stringRepeat(" ",i-1);
16041c16043
<                 ? lang.stringRepeat(this.TAB_CHAR, this.tabSize)
---
>                 ? this.TAB_CHAR + lang.stringRepeat(" ", this.tabSize-1)
*/

var idAceTimer = null;
var aryAceEditors = new Array();
var nSignal = 0;

function DoUndo(oEdit)
{	if (oEdit.pxplus_chg_delay == 0) oEdit.pxplus_next_chg = true;
	oEdit.undo(false);
	if (oEdit.pxplus_chg_delay > 2) oEdit.pxplus_chg_tmr = oEdit.pxplus_chg_delay - 1;
	return oEdit.getSession().getUndoManager().hasUndo();
}
  
function DoRedo(oEdit)
{	if (oEdit.pxplus_chg_delay == 0) oEdit.pxplus_next_chg = true;
	oEdit.redo();
	if (oEdit.pxplus_chg_delay > 2) oEdit.pxplus_chg_tmr = oEdit.pxplus_chg_delay - 1;
	return oEdit.getSession().getUndoManager().hasRedo();
}

function AceInit(oEdit, sId, nFontSize, nTabSize, bShowInvisibles, bTabsAsSpaces)
{	oEdit.pxplus_sId = sId;
	oEdit.pxplus_next_chg = 0;
	oEdit.pxplus_chg_delay = 0;
	oEdit.pxplus_chg = 0;
	oEdit.pxplus_chg_tmr = 0;
	oEdit.setFontSize(nFontSize);
	if (bTabsAsSpaces==1)
	{	oEdit.getSession().setUseSoftTabs(true);
		oEdit.getSession().setNavigateWithinSoftTabs(true);
	}
	else
	{	oEdit.getSession().setUseSoftTabs(false);
	}
	oEdit.getSession().setTabSize(nTabSize);
	oEdit.setShowInvisibles(bShowInvisibles);
	oEdit.on('change', function() { AceChange(oEdit); } );
	oEdit.on('blur', function(){ AceBlur(oEdit); } );
	aryAceEditors.push(oEdit);
	idAceTimer = setInterval(AceTimer, 1000);

	/* Disable settings menu since we have our own */
	oEdit.commands.removeCommands(["showSettingsMenu"]);

	/* Disable toggle block comments since Pxplus does not have block comments */
	oEdit.commands.removeCommands(["toggleBlockComment"]);

	/* Modify some exisitng shortcuts to avoid conflict with our shortcuts below */
	var jumptomatching = oEdit.commands.byName["jumptomatching"];
	jumptomatching.bindKey = {win: "Ctrl-B", mac: "Ctrl-B"};
	oEdit.commands.addCommand(jumptomatching);
	var selecttomatching = oEdit.commands.byName["selecttomatching"];
	selecttomatching.bindKey = {win: "Ctrl-Shift-B", mac: "Ctrl-Shift-B"};
	oEdit.commands.addCommand(selecttomatching);
	var splitline = oEdit.commands.byName["splitline"];
	splitline.bindKey = {win: "Ctrl-I", mac: "Ctrl-I"};
	oEdit.commands.addCommand(splitline);
	var golineup = oEdit.commands.byName["golineup"];
	golineup.bindKey = {win: "Up", mac: "Up"};
	oEdit.commands.addCommand(golineup);
	var golinedown = oEdit.commands.byName["golinedown"];
	golinedown.bindKey = {win: "Down", mac: "Down"};
	oEdit.commands.addCommand(golinedown);
	var selectOrFindNext = oEdit.commands.byName["selectOrFindNext"];
	selectOrFindNext.bindKey = {win: "Alt-K", mac: "Alt-K"};
	oEdit.commands.addCommand(selectOrFindNext);
	var selectOrFindPrevious = oEdit.commands.byName["selectOrFindPrevious"];
	selectOrFindPrevious.bindKey = {win: "Shift-Alt-K", mac: "Shift-Alt-K"};
	oEdit.commands.addCommand(selectOrFindPrevious);

	/* Add our own shortcuts to Ace */
	oEdit.commands.addCommands([{
		name: "closefile",
		bindKey: {win: "F4", mac: "F4"},
		exec: function(editor) { AceSignal(editor, "close"); },
		readOnly: true
	}, {
		name: "openfile",
		bindKey: {win: "Ctrl-O", mac: "Ctrl-O"},
		exec: function(editor) { AceSignal(editor, "open"); },
		readOnly: true
	}, {
		name: "newfile",
		bindKey: {win: "Ctrl-N", mac: "Ctrl-N"},
		exec: function(editor) { AceSignal(editor, "new"); },
		readOnly: true
	}, {
		name: "savefile",
		bindKey: {win: "Ctrl-S", mac: "Command-S"},
		exec: function(editor) { AceSave(editor); },
		scrollIntoView: "center",
		readOnly: true
	}, {
		name: "printfile",
		bindKey: {win: "Ctrl-P", mac: "Ctrl-P"},
		exec: function(editor) { AceSignal(editor, "print"); },
		readOnly: true
	}, {
		name: "gotofile",
		bindKey: {win: "Ctrl-G", mac: "Ctrl-G"},
		exec: function(editor) { AceSignal(editor, "goto"); },
		readOnly: true
	}]);

	/* Load module to allow shortcuts display screen */
	ace.config.loadModule("ace/ext/keybinding_menu", function(e) {e.init(oEdit);});
}

function AceSave(oEdit)
{	AceSignal(oEdit, "save");
}

function AceChange(oEdit)
{	if (oEdit.pxplus_next_chg == 2) return;

	if (typeof webster !== 'undefined' && webster) _Id('isChangeId').value=1;
	oEdit.pxplus_chg = true;
	if ((oEdit.pxplus_chg_delay < 0) || (oEdit.pxplus_next_chg))
	{	AceSignalChg(oEdit);
		return;
	}
}

function AceBlur(oEdit)
{	AceSignal(oEdit, "blur");
	return;
}

function AceSignalNextChg(oEdit)
{	oEdit.pxplus_next_chg = 1;
}

function AceSignalChg(oEdit)
{	oEdit.pxplus_chg_tmr = 0;
	oEdit.pxplus_next_chg = 0;

	AceSignal(oEdit, "chg");
}

function AceTimer()
{	var oEdit;

	for (var i = 0; i < aryAceEditors.length; i++)
	{	oEdit = aryAceEditors[i];
		if (oEdit.pxplus_chg_delay > 0)
		{	oEdit.pxplus_chg_tmr++;
			if (oEdit.pxplus_chg)
			{	if ((oEdit.pxplus_chg_tmr > oEdit.pxplus_chg_delay) || (oEdit.getCursorPosition().row != oEdit.pxplus_chg_line)) AceSignalChg(oEdit);
			}
		}
	}
}

function AceSetChangeDelay(oEdit, nSec)
{	oEdit.pxplus_chg_delay = nSec;
}

function AceSignal(oEdit, sCmd)
{	if (oEdit.pxplus_chg)
		sCmd += ',1';
	else
		sCmd += ',0';
	
	if (typeof iNmd_Signal == 'function') 
	{	iNmd_Signal(oEdit.pxplus_sId, sCmd);
	}
	else if (typeof webster !== 'undefined' && webster)
	{	oEdit.pxplus_chg_line = oEdit.getCursorPosition().row;
		if (oEdit.pxplus_chg)
		{	_Id('saveCode').value=oEdit.getValue();
			_Evt('form_1','change','');
		}
		if (sCmd.startsWith('save'))
			_Evt('form_1','save','');
	}
	else
	{	nSignal++;
		document.title = 'Sig#' + nSignal+ ':' + sCmd;
	}
}
function AceLoad(oEdit, sValue)
{	oEdit.pxplus_next_chg = 2;
	oEdit.setValue(sValue);
	
	oEdit.clearSelection();
	oEdit.pxplus_chg_tmr = 0;

}

function AceStatus(oEdit)
{	var oCursor = oEdit.selection.getCursor();
	var oUndo = oEdit.getSession().getUndoManager();

	var sInfo = 
		oCursor.row.toString() + ',' + 
		oCursor.column.toString() + ',' + 
		oEdit.getSession().getScrollTop().toString() + ',' + 
		(oUndo.hasUndo() ? '1,' : '0,') + 
		(oUndo.hasRedo() ? '1' : '0');

	var sVal = '';
	if (oEdit.pxplus_chg)
	{	oEdit.pxplus_chg = false;
		oEdit.pxplus_chg_line = oEdit.getCursorPosition().row;
		oEdit.pxplus_chg_tmr = 0;
		sVal =  ',' + oEdit.getValue();
	}
	return sInfo + sVal;
}
function AceGetPosition(oEdit)
{	var oCursor = oEdit.selection.getCursor();
	return oCursor.row.toString() + ',' + oCursor.column.toString() + ',' + oEdit.getSession().getScrollTop().toString();
}

function AceSetPosition(oEdit, nRow, nCol, nTop, nReset, bGoToTop=false)
{	oEdit.gotoLine(nRow+1, nCol, false);
	if (nTop < 0)
		oEdit.scrollToLine((bGoToTop ? nRow : nRow+1), !bGoToTop, false, null);
	else
		oEdit.getSession().setScrollTop(nTop);

	if (!nReset) return;

	oEdit.getSession().getUndoManager().reset();
	oEdit.pxplus_chg = 0;
}


function PropDump(objectname, object) 
{	var wNew = window.open('','','height=600,width=800,toolbar=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,location=no');
	var sVal;
	
	wNew.document.writeln('<html><body>');

	wNew.document.writeln("<table border=1 bgcolor=wheat><tr>");
	wNew.document.writeln("<td style='font-size: 18pt; font-weight: bold' colspan=2 align=center>");
	wNew.document.writeln("Properties of the <code>"+objectname+"</code> object</td></tr>");

	for (prop in object)
	{	if ((prop == 'innerHTML') || (prop == 'outerHTML'))
			sVal = "..suppressed..";
		else
			sVal =  object[prop];

		wNew.document.writeln("<tr><th>"+prop+"</th><td>" +  sVal +"</td></tr>");
	}

	wNew.document.writeln("</table><p>");
	wNew.document.writeln('</body></html>');
	wNew.document.close();
	return;
}

function AceSearch(oEdit, isReplace)
{	 ace.config.loadModule("ace/ext/searchbox", function(e) {e.Search(oEdit, isReplace)});
}

/* Include this here so it can be used for a workaround of a ace bug. This is taken from within ace.js  */
var editorCss = ".ace_editor {\
position: relative;\
overflow: hidden;\
font: 12px/normal 'Monaco', 'Menlo', 'Ubuntu Mono', 'Consolas', 'source-code-pro', monospace;\
direction: ltr;\
}\
.ace_scroller {\
position: absolute;\
overflow: hidden;\
top: 0;\
bottom: 0;\
background-color: inherit;\
-ms-user-select: none;\
-moz-user-select: none;\
-webkit-user-select: none;\
user-select: none;\
cursor: text;\
}\
.ace_content {\
position: absolute;\
-moz-box-sizing: border-box;\
-webkit-box-sizing: border-box;\
box-sizing: border-box;\
min-width: 100%;\
}\
.ace_dragging .ace_scroller:before{\
position: absolute;\
top: 0;\
left: 0;\
right: 0;\
bottom: 0;\
content: '';\
background: rgba(250, 250, 250, 0.01);\
z-index: 1000;\
}\
.ace_dragging.ace_dark .ace_scroller:before{\
background: rgba(0, 0, 0, 0.01);\
}\
.ace_selecting, .ace_selecting * {\
cursor: text !important;\
}\
.ace_gutter {\
position: absolute;\
overflow : hidden;\
width: auto;\
top: 0;\
bottom: 0;\
left: 0;\
cursor: default;\
z-index: 4;\
-ms-user-select: none;\
-moz-user-select: none;\
-webkit-user-select: none;\
user-select: none;\
}\
.ace_gutter-active-line {\
position: absolute;\
left: 0;\
right: 0;\
}\
.ace_scroller.ace_scroll-left {\
box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;\
}\
.ace_gutter-cell {\
padding-left: 19px;\
padding-right: 6px;\
background-repeat: no-repeat;\
}\
.ace_gutter-cell.ace_error {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==\");\
background-repeat: no-repeat;\
background-position: 2px center;\
}\
.ace_gutter-cell.ace_warning {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==\");\
background-position: 2px center;\
}\
.ace_gutter-cell.ace_info {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=\");\
background-position: 2px center;\
}\
.ace_dark .ace_gutter-cell.ace_info {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC\");\
}\
.ace_scrollbar {\
position: absolute;\
right: 0;\
bottom: 0;\
z-index: 6;\
}\
.ace_scrollbar-inner {\
position: absolute;\
cursor: text;\
left: 0;\
top: 0;\
}\
.ace_scrollbar-v{\
overflow-x: hidden;\
overflow-y: scroll;\
top: 0;\
}\
.ace_scrollbar-h {\
overflow-x: scroll;\
overflow-y: hidden;\
left: 0;\
}\
.ace_print-margin {\
position: absolute;\
height: 100%;\
}\
.ace_text-input {\
position: absolute;\
z-index: 0;\
width: 0.5em;\
height: 1em;\
opacity: 0;\
background: transparent;\
-moz-appearance: none;\
appearance: none;\
border: none;\
resize: none;\
outline: none;\
overflow: hidden;\
font: inherit;\
padding: 0 1px;\
margin: 0 -1px;\
text-indent: -1em;\
-ms-user-select: text;\
-moz-user-select: text;\
-webkit-user-select: text;\
user-select: text;\
white-space: pre!important;\
}\
.ace_text-input.ace_composition {\
background: inherit;\
color: inherit;\
z-index: 1000;\
opacity: 1;\
text-indent: 0;\
}\
.ace_layer {\
z-index: 1;\
position: absolute;\
overflow: hidden;\
word-wrap: normal;\
white-space: pre;\
height: 100%;\
width: 100%;\
-moz-box-sizing: border-box;\
-webkit-box-sizing: border-box;\
box-sizing: border-box;\
pointer-events: none;\
}\
.ace_gutter-layer {\
position: relative;\
width: auto;\
text-align: right;\
pointer-events: auto;\
}\
.ace_text-layer {\
font: inherit !important;\
}\
.ace_cjk {\
display: inline-block;\
text-align: center;\
}\
.ace_cursor-layer {\
z-index: 4;\
}\
.ace_cursor {\
z-index: 4;\
position: absolute;\
-moz-box-sizing: border-box;\
-webkit-box-sizing: border-box;\
box-sizing: border-box;\
border-left: 2px solid;\
transform: translatez(0);\
}\
.ace_slim-cursors .ace_cursor {\
border-left-width: 1px;\
}\
.ace_overwrite-cursors .ace_cursor {\
border-left-width: 0;\
border-bottom: 1px solid;\
}\
.ace_hidden-cursors .ace_cursor {\
opacity: 0.2;\
}\
.ace_smooth-blinking .ace_cursor {\
-webkit-transition: opacity 0.18s;\
transition: opacity 0.18s;\
}\
.ace_editor.ace_multiselect .ace_cursor {\
border-left-width: 1px;\
}\
.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {\
position: absolute;\
z-index: 3;\
}\
.ace_marker-layer .ace_selection {\
position: absolute;\
z-index: 5;\
}\
.ace_marker-layer .ace_bracket {\
position: absolute;\
z-index: 6;\
}\
.ace_marker-layer .ace_active-line {\
position: absolute;\
z-index: 2;\
}\
.ace_marker-layer .ace_selected-word {\
position: absolute;\
z-index: 4;\
-moz-box-sizing: border-box;\
-webkit-box-sizing: border-box;\
box-sizing: border-box;\
}\
.ace_line .ace_fold {\
-moz-box-sizing: border-box;\
-webkit-box-sizing: border-box;\
box-sizing: border-box;\
display: inline-block;\
height: 11px;\
margin-top: -2px;\
vertical-align: middle;\
background-image:\
url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII=\"),\
url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=\");\
background-repeat: no-repeat, repeat-x;\
background-position: center center, top left;\
color: transparent;\
border: 1px solid black;\
border-radius: 2px;\
cursor: pointer;\
pointer-events: auto;\
}\
.ace_dark .ace_fold {\
}\
.ace_fold:hover{\
background-image:\
url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII=\"),\
url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC\");\
}\
.ace_tooltip {\
background-color: #FFF;\
background-image: -webkit-linear-gradient(top, transparent, rgba(0, 0, 0, 0.1));\
background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));\
border: 1px solid gray;\
border-radius: 1px;\
box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);\
color: black;\
max-width: 100%;\
padding: 3px 4px;\
position: fixed;\
z-index: 999999;\
-moz-box-sizing: border-box;\
-webkit-box-sizing: border-box;\
box-sizing: border-box;\
cursor: default;\
white-space: pre;\
word-wrap: break-word;\
line-height: normal;\
font-style: normal;\
font-weight: normal;\
letter-spacing: normal;\
pointer-events: none;\
}\
.ace_folding-enabled > .ace_gutter-cell {\
padding-right: 13px;\
}\
.ace_fold-widget {\
-moz-box-sizing: border-box;\
-webkit-box-sizing: border-box;\
box-sizing: border-box;\
margin: 0 -12px 0 1px;\
display: none;\
width: 11px;\
vertical-align: top;\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==\");\
background-repeat: no-repeat;\
background-position: center;\
border-radius: 3px;\
border: 1px solid transparent;\
cursor: pointer;\
}\
.ace_folding-enabled .ace_fold-widget {\
display: inline-block;   \
}\
.ace_fold-widget.ace_end {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==\");\
}\
.ace_fold-widget.ace_closed {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==\");\
}\
.ace_fold-widget:hover {\
border: 1px solid rgba(0, 0, 0, 0.3);\
background-color: rgba(255, 255, 255, 0.2);\
box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);\
}\
.ace_fold-widget:active {\
border: 1px solid rgba(0, 0, 0, 0.4);\
background-color: rgba(0, 0, 0, 0.05);\
box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);\
}\
.ace_dark .ace_fold-widget {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC\");\
}\
.ace_dark .ace_fold-widget.ace_end {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==\");\
}\
.ace_dark .ace_fold-widget.ace_closed {\
background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==\");\
}\
.ace_dark .ace_fold-widget:hover {\
box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);\
background-color: rgba(255, 255, 255, 0.1);\
}\
.ace_dark .ace_fold-widget:active {\
box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);\
}\
.ace_fold-widget.ace_invalid {\
background-color: #FFB4B4;\
border-color: #DE5555;\
}\
.ace_fade-fold-widgets .ace_fold-widget {\
-webkit-transition: opacity 0.4s ease 0.05s;\
transition: opacity 0.4s ease 0.05s;\
opacity: 0;\
}\
.ace_fade-fold-widgets:hover .ace_fold-widget {\
-webkit-transition: opacity 0.05s ease 0.05s;\
transition: opacity 0.05s ease 0.05s;\
opacity:1;\
}\
.ace_underline {\
text-decoration: underline;\
}\
.ace_bold {\
font-weight: bold;\
}\
.ace_nobold .ace_bold {\
font-weight: normal;\
}\
.ace_italic {\
font-style: italic;\
}\
.ace_error-marker {\
background-color: rgba(255, 0, 0,0.2);\
position: absolute;\
z-index: 9;\
}\
.ace_highlight-marker {\
background-color: rgba(255, 255, 0,0.2);\
position: absolute;\
z-index: 8;\
}\
.ace_br1 {border-top-left-radius    : 3px;}\
.ace_br2 {border-top-right-radius   : 3px;}\
.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}\
.ace_br4 {border-bottom-right-radius: 3px;}\
.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}\
.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}\
.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}\
.ace_br8 {border-bottom-left-radius : 3px;}\
.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}\
.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}\
.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}\
.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\
.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\
.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}\
.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}\
";
